/*
*
*/

var ServiceContext = Packages.de.intarsys.service.common.ServiceContext;
var ArgTools = Packages.de.intarsys.tools.functor.ArgTools;
var AttachmentTools = Packages.de.intarsys.tools.attachment.AttachmentTools;
var tempId = ServiceContext.service.serviceConfig.serviceContainer.id;
var tempLogger = _service.getAttribute("logger");

var result = null;
var args = Reflector.args();

tempLogger.info("processing timestamp request");

var timestampDevice = Packages.de.intarsys.security.device.timestamp.device.TimestampTools.lookupDevice(timestampServiceName);
if (timestampDevice == null) {
	throw "No timestamp service found with id + '" + timestampServiceName + "'";
}
var timestampCreatorArgs = Packages.de.intarsys.tools.functor.Args.create();
var timestampCreator = timestampDevice.createApplication("de.intarsys.security.app.timestamp.ITimestampCreator", timestampCreatorArgs);

var encTimestampRequest = Packages.de.intarsys.tools.locator.LocatorTools.getBytes(document.locator);
var timestampRequest = new Packages.de.intarsys.security.tsa.rfc3161.RFC3161TimestampRequest(encTimestampRequest);
var timestampResponse = timestampCreator.createTimestamp(timestampRequest);
var encTimestampResponse = timestampResponse.getEncoded();
result = new Packages.de.intarsys.tools.result.ByteBasedResult(encTimestampResponse, "application/timestamp-reply");

tempLogger.info("processed timestamp request");

result;
