/*
 *
 */

var ServiceContext = Packages.de.intarsys.service.common.ServiceContext;
var ArgTools = Packages.de.intarsys.tools.functor.ArgTools;
var tempId = ServiceContext.service.serviceConfig.serviceContainer.id;
var tempLogger = _service.getAttribute("logger");
var Args = Packages.de.intarsys.tools.functor.Args;

var result = null;
var args = Reflector.args();

tempLogger.info("validating certificate signatures...");

var api = new Packages.de.intarsys.stage.signlive.api.impl.SignLiveAPIImpl();
api.connect(Args.create());
try {
	result = api.validateCertificate(args);
} finally {
	api.disconnect();
}

var returnMode = Packages.de.intarsys.tools.functor.ResultTools
		.getResultReturnMode(args);
if (returnMode == Packages.de.intarsys.tools.functor.EnumReturnMode.COMPOSITE) {
	var state = ArgTools.getInt(result, "state", -1);
	var resultText = "undefined";
	if (state == 0) {
		resultText = "valid";
	} else if (state == 3) {
		resultText = "invalid";
	} else if (state == 2) {
		resultText = "unknown";
	}
	tempLogger.info("certificate validated, result: " + resultText);
	ServiceContext.serviceRequest.setAttribute("resultDir", resultText + "/");
}

result;
