/*
 *
 */

var ServiceContext = Packages.de.intarsys.service.common.ServiceContext;
var ArgTools = Packages.de.intarsys.tools.functor.ArgTools;
var AttachmentTools = Packages.de.intarsys.tools.attachment.AttachmentTools;
var tempId = ServiceContext.service.serviceConfig.serviceContainer.id;
var tempLogger = _service.getAttribute("logger");
var Args = Packages.de.intarsys.tools.functor.Args;

var result = null;
var args = Reflector.args();

tempLogger.info("validating signatures of '" + document.locator.fullName + "'...");

var api = new Packages.de.intarsys.stage.signlive.api.impl.SignLiveAPIImpl();
api.connect(Args.create());
try {
	result = api.validateDocument(args);
} finally {
	api.disconnect();
}
processResult(document, result);

function processResult(document, result) {
	var signedDocument = Packages.com.cabaret.security.document.validation.SignedDocument.getSignedDocument(document);
	var signedDocumentState = signedDocument.getState();
	if (shallRetry(signedDocumentState)) {
		throw new Packages.de.intarsys.service.api.ServiceRetryException("Status unknown, retry...");
	}
	
	var returnMode = Packages.de.intarsys.tools.functor.ResultTools.getResultReturnMode(args);
	if (returnMode == Packages.de.intarsys.tools.functor.EnumReturnMode.COMPOSITE) {
		var state = ArgTools.getInt(result, "state", -1);

		var signatures = ArgTools.getArgs(result, "signatures", Args.create());
		var signatureCount = signatures.size();

		var resultText = "undefined";
		if (signatureCount == 0) {
			resultText = "no signatures";
		} else if (state == 0) {
			resultText = "valid";
		} else if (state == 3) {
			resultText = "invalid";
		} else if (state == 2) {
			resultText = "unknown";		
		}
		tempLogger.info("signatures validated, result: " + resultText);
		ServiceContext.serviceRequest.setAttribute("resultDir", resultText + "/");

		var reportLocator = ArgTools.getLocator(result, "report", null, Packages.de.intarsys.document.common.DocumentLocatorFactory.get());
		if (reportLocator == null) {
			tempLogger.info("no validation report created");
		} else {
			if (reportLocator.equals(document.locator)) {
				// report was appended
				if (document.changed) {
					document.save();
				}
			} else {
				// standalone report
				AttachmentTools.addAttachment(reportLocator.typedName, reportLocator);
			}
			tempLogger.info("validation report created");
		}
	}
}

function shallRetry(signedDocumentState) {
	if (!ArgTools.getBoolean(args, "mayRetry", false)) {
		tempLogger.debug("no retry - mayRetry is false");
		return false;
	}
	if (signedDocumentState.isValid()) {
		tempLogger.debug("no retry - state is valid");
		return false;
	}
	tempLogger.debug("state is {}, checking if recoverable...", signedDocumentState.getState());
	if (signedDocumentState.isRecoverable()) {
		tempLogger.debug("will retry - state is recoverable");
		return true;
	}
	tempLogger.debug("no retry - state is not recoverable");
	return false;
}

result;
