var path = "com.cabaret.application.sendmail.messages";   
var classpath = Reflector.locator().parent.fullName + "/resources";
var MSG = Packages.de.intarsys.tools.message.MessageTools.getMessageBundle(path, classpath);
 
var attachments = new Array();
var counter = 0;

if (jEvent.target == null) {
	// no document selected
	var title = MSG.getString("scripts.sendmailSubject.NoDocumentTitle");
	var msg = MSG.getString("scripts.sendmailSubject.NoDocumentMessage"); 
	Packages.de.intarsys.tools.reporter.Reporter.get().reportMessage(title, msg, 0);
} else {
	var doc = jEvent.target.document;
	if (doc.isChanged() || !doc.locator.exists()) {
		// document changed...
		var title = MSG.getString("scripts.sendmailSubject.NotSavedTitle");
		var msg = MSG.getString("scripts.sendmailSubject.NotSavedMessage"); 
		Packages.de.intarsys.tools.reporter.Reporter.get().reportMessage(title, msg, 0);
	} else {
		attachments[counter++]= doc.locator.fullName;
		var args = Packages.de.intarsys.tools.functor.Args.create();
		var docAttachments = doc.invoke("getMailAttachments", args)
		for each (var docAttachment in docAttachments) {
			attachments[counter++]= docAttachment.fullName;
		}
	}
}

if (counter > 0) {
	var subject = jVariables.getNamespace("global").getVariable("MailSubject");
	if (subject == null) {
		subject = MSG.getString("scripts.sendmailSubject.MailSubject"); 
	}
	var msg = jVariables.getNamespace("global").getVariable("MailMessage");
	if (msg == null) {
		msg = MSG.getString("scripts.sendmailSubject.MailMessage"); 
	}
	try {
		xutil.mail({
			cTo: "",
			cSubject: subject,
			cMsg: msg,
			cAttachments: attachments,
			bUseTempFiles: true
		});					
	} catch (e) {
		//
	}
}
