/*
 *  
 *    intarsys GmbH (c)
 *  
 *   
 *   
 *  
 * 
 * Handle a document data stream.
 * 
 * Default is to treat as a PS data stream, convert to PDF and view the resulting 
 * document.
 * 
 */
function print() {
	try {
		var importedIDoc = Processor.callArgs(
			"com.cabaret.pdf.exchange.ps.PSImporterFactory", {
			importLocator: document.locator,
			outputLocator: outputLocator
		});
		if (importedIDoc == null) {
			return null;
		}
		if (append) {
			var tempDocument = jApplication.getAttribute("currentDocument"); 
			if (tempDocument == null || tempDocument.referenceCount == 0) {
				// remember and watch new document
				tempDocument = importedIDoc;
				jApplication.setAttribute("currentDocument", tempDocument);
				var destroyedType = Packages.de.intarsys.tools.event.DestroyedEvent.ID;
				var receiver = new Object();
				receiver.handleEvent = function() {
					// this is an ugly workaround for malformed scopes
					// jApplication not available here
					Packages.com.cabaret.claptz.application.model.Application.get()
							.removeAttribute("currentDocument");
				};
				var callback = new Packages.de.intarsys.tools.event.INotificationListener(receiver);
				tempDocument.addNotificationListener(destroyedType, callback);
			} else {
				Processor.callArgs(
						"com.cabaret.pdf.processor.pageimporter.PageImporterFactory",{
							document: tempDocument,
							sourceDocument: importedIDoc
						}
					);
			}
			if (view) {
				// bring current document to front
				Processor.callArgs(
						"DocumentViewerFactory", {
						document: tempDocument
					});
			} else {
				Packages.de.intarsys.tools.reporter.Reporter.get().reportStatus("Printing " + tempDocument.locator.localName + " ready", 0);
			}
			return tempDocument.locator;
		} else {
			// var pddoc = idocu.impl;
			// pddoc.producer = jStage.name + " " + jStage.major + "." + jStage.minor;
			if (view) {
				// show new printed document
				Processor.callArgs(
						"DocumentViewerFactory", {
						document: importedIDoc 
					});
			} else {
				Packages.de.intarsys.tools.reporter.Reporter.get().reportStatus("Printing " + importedIDoc.locator.localName + " ready", 0);
			}
		} 
		return importedIDoc.locator;
	} finally {
		if (importedIDoc != null) {
			importedIDoc.release(null);
		}
	}
}

var result = print();
result;
