/*
	Create an IDocument object from the input stream. If appropriate, 
	a document conversion is applied.
*/
var ArgTools = Packages.de.intarsys.tools.functor.ArgTools;

cosima.logger.debug("cosima.archiver.invoke enter");
if (factory == null || factory == "") {
	cosima.logger.debug("cosima.archiver.invoke disabled");
} else {
	cosima.logger.info("cosima.archiver.invoke via " + factory);
	// inject resolver
	var lcTagResolver = new Packages.de.intarsys.tools.expression.TagResolver(cosima.document);
	var lcResolver = new Packages.de.intarsys.tools.expression.MapResolver();
	lcResolver.put("tags", lcTagResolver);
	args.put("resolver", lcResolver);
	args.put("document", cosima.document);
	
	var wizard = ArgTools.getString(args, "wizard", "none");
	var interactive = wizard != "none";
	var wizardFactory = null;
	if (interactive) {
		wizardFactory = Packages.com.cabaret.claptz.common.wizard.WizardTools.lookupWizardFactoryForTargetFactory(factory);
	}
	if (wizardFactory == null) {
		Processor.callArgs(factory, args);
	} else {
		Wizard.callArgs(wizardFactory.id, args);
	}
}
cosima.logger.debug("cosima.archiver.invoke leave");

