/*
	Create an IDocument object from the input stream. If appropriate, 
	a document conversion is applied.
*/
var ArgTools = Packages.de.intarsys.tools.functor.ArgTools;
var AttachmentTools = Packages.de.intarsys.tools.attachment.AttachmentTools;

cosima.logger.debug("cosima.converter.invoke enter");
if (factory == null || factory == "") {
	cosima.logger.debug("cosima.converter.invoke disabled");
	cosima.document = cosima.input;
	cosima.document.acquire();
} else {
	args.put("importLocator", cosima.input.locator);
	cosima.logger.info("cosima.converter.invoke convert '" + cosima.input.locator.fullName + "' via " + factory);
	cosima.document = Processor.callArgs(factory, args);
	// add an attachment to the current thread
	AttachmentTools.addAttachment(cosima.document.locator.typedName, cosima.document.locator);
	cosima.logger.info("cosima.converter.invoke created document '" + cosima.document.locator.fullName + "'");
}
cosima.logger.debug("cosima.converter.invoke leave");



