var ArgTools = Packages.de.intarsys.tools.functor.ArgTools;
var ServiceContext = Packages.de.intarsys.service.common.ServiceContext;
var MSG = Packages.de.intarsys.tools.message.MessageTools.getMessageBundle(Packages.de.intarsys.service.cosima.CosimaService);

// setup a common cosima for all process tasks
var cosima = new Object();
var lcArgs = Reflector.args();
lcArgs.cosima = cosima;
var lcID = ServiceContext.service.serviceConfig.serviceContainer.id;
cosima.args = lcArgs;
cosima.logger = _service.getAttribute("logger");
cosima.input = document;
cosima.attachments = attachments;
 
var lcLogger = cosima.logger;

function call(module, args, cosima) {
	var lcSubArgs = args.get(module);
	if (!lcSubArgs) {
		lcSubArgs = ArgTools.createArgs();
	}
	lcSubArgs.put("cosima", cosima);
	if (!lcSubArgs.get("args")) {
		lcSubArgs.put("args", ArgTools.createArgs());
	}
	if (!lcSubArgs.get("factory")) {
		lcSubArgs.put("factory", lcSubArgs.get("processor"));
	}
	Script.callArgs(module + "/invoke", lcSubArgs);
}

lcLogger.info("cosima.invoke enter");
var context = Packages.de.intarsys.tools.session.ActivityContext.get();
context.acquire();
var message = MSG.getMessage("cosima.state.active");
var monitor = Packages.de.intarsys.tools.reporter.Reporter.get().reportActivityStart(message, 0); 
try {
	call("converter", lcArgs, cosima);
	call("tagger", lcArgs, cosima); 
	call("worker_before", lcArgs, cosima);
	call("signer", lcArgs, cosima);
	call("worker_after", lcArgs, cosima);
	call("validator", lcArgs, cosima);
	call("mailer", lcArgs, cosima);
	call("archiver", lcArgs, cosima);
	call("notifier", lcArgs, cosima);
} finally {
	context.release(null);
	monitor.end();
	call("postprocess", lcArgs, cosima);
	if (cosima.document != null) {
		Packages.de.intarsys.tools.reporter.Reporter.get().reportStatus("cosima processed " + cosima.document.locator.typedName, 0);
		cosima.document.release(null);
	}
	lcLogger.info("cosima.invoke leave");
}
