var ArgTools = Packages.de.intarsys.tools.functor.ArgTools;

cosima.logger.debug("cosima.mailer.invoke enter");
if (factory == null || factory == "") {
	cosima.logger.info("cosima.mailer.invoke disabled");
} else {
	cosima.logger.info("cosima.mailer.invoke via " + factory);
	
	// adding attachments
	var lcAttachments = new Array();
	lcAttachments[0]= cosima.document.locator.fullName;
	if (cosima.signatureContainer != null && cosima.document.locator != cosima.signatureContainer.locator) {
		// detached signature
		lcAttachments[1]= cosima.signatureContainer.locator.fullName;
	}
	args.put("attachments", ScriptTools.toJavaObject(lcAttachments));
	
	// mapping dedicated tags
	if (cosima.tags.emailTo != null) {
		args.put("to", cosima.tags.emailTo);
	}
	if (cosima.tags.emailCc != null) {
		args.put("cc", cosima.tags.emailCc);
	}
	if (cosima.tags.emailSubject != null) {
		args.put("subject", cosima.tags.emailSubject);
	}
	if (cosima.tags.emailMsg != null) {
		args.put("msg", cosima.tags.emailMsg);
	}
	if (cosima.tags.emailMsgLocator != null) {
		args.put("msgLocator", cosima.tags.emailMsgLocator);
	}
	
	// MAPI settings - ignored by SMTP
	if (cosima.tags.emailInteractive != null) {
		args.put("interactive", cosima.tags.emailInteractive);
	}
	
	// inject resolver
	var lcTagResolver = new Packages.de.intarsys.tools.expression.TagResolver(cosima.document);
	var lcResolver = new Packages.de.intarsys.tools.expression.MapResolver();
	lcResolver.put("tags", lcTagResolver);
	args.put("resolver", lcResolver);
	
	Processor.callArgs(factory, args);			
}
cosima.logger.debug("cosima.mailer.invoke leave");
