Reflector.declareArg("cosima");
var ServiceContext = Packages.de.intarsys.service.common.ServiceContext;

try {
	var lcPoolId = ServiceContext.getServiceParameter("signer.args.digestSigner.args.pool", null);
	if (lcPoolId == null) {
		cosima.logger.info("cosima.sign.init smartcard pool not defined in parameters");
	} else {
		cosima.logger.info("cosima.sign.init smartcard pool '" +  lcPoolId + "' signature service intialize...");
		var tempRegistry = Packages.de.intarsys.security.device.pool.device.PoolRegistry.get();
		if (tempRegistry == null) {
			throw new Error("Signature pool registry missing");
		}
		var tempPool = tempRegistry.lookupPool(lcPoolId);
		if (tempPool == null) {
			throw new Error("Signature pool '" + lcPoolId + "' missing");
		}
		if (!tempPool.started) {
			if (tempPool.autoStart) {
				cosima.logger.info("cosima.sign.init smartcard pool '" + lcPoolId + "' auto start...");
				tempPool.start();
				cosima.logger.info("cosima.sign.init smartcard pool '" + lcPoolId + "' auto started");
			} else {
				throw new Error("Signature pool '" + lcPoolId + "' not started");
			}
		}
	}
} catch(e) {
	cosima.logger.info("cosima.sign.init smartcard pool '" + lcPoolId + "' signature service intialization failed (" + e + ")");
	throw e; 
}

