/*
	Detect tags
*/

var ArgTools = Packages.de.intarsys.tools.functor.ArgTools;

cosima.logger.debug("cosima.tagger.invoke enter");
if (factory == null || factory == "") {
	cosima.logger.info("cosima.tagger.invoke disabled");
} else {
	cosima.logger.debug("cosima.tagger.invoke via " + factory);
	
	// detect tags
	args.put("document", cosima.document);
	args.put("attachments", cosima.attachments);
	Processor.callArgs(factory, args);	
	
	// merge args from tags - the cosima way
	cosima.tags = new Object();
	var lcTags = Packages.de.intarsys.tools.tag.TagTools.getTags(cosima.document);
	var tempArgs = ArgTools.createArgs();
	for each (var lcTag in lcTags) {
		var lcKey = lcTag.key;
		var lcValue = lcTag.value;
		var lcCanonicalKey = Packages.de.intarsys.service.cosima.tags.Tags.canonicalName(lcKey);
		cosima.tags[lcKey] = lcValue;
		cosima.tags[lcCanonicalKey] = lcValue;
		cosima.logger.info("cosima.tag.invoke detect tag " + lcKey + " (" + lcCanonicalKey + ") = " + lcValue);
		// check if tag key === "cosima"
		if (lcCanonicalKey == "cosima") {
			ArgTools.putDefinition(cosima.args, lcValue);
		}
	}
	
	// merge args from tags - the standard way
	var tempArgs = ArgTools.createArgs();
	tempArgs.put("args", cosima.args);
	tempArgs.put("target", cosima.document); 
	Functor.callArgs("de.intarsys.tools.tag.TagsToArgsFunctor", tempArgs);
	
	// provide resolver context
	// get this either in a functor or in the tagging processor itself
	// be aware of resource leaks in activity context
	var resolver = new Packages.de.intarsys.tools.expression.TagResolver(cosima.document);
	resolver = Packages.de.intarsys.tools.expression.MapResolver.create("tags", resolver);
	Packages.de.intarsys.tools.expression.ActivityContextAwareResolver.attach(resolver);
	
	// "crunch" arguments some more...
	var tempArgs = ArgTools.getArgs(cosima.args, "cruncher", ArgTools.createArgs()).copy();
	tempArgs.put("args", cosima.args);
	Functor.callArgs("de.intarsys.tools.functor.ArgsCruncher", tempArgs);

}
cosima.logger.debug("cosima.tagger.invoke leave");

