#!/bin/bash

if [ -z "$2" ]; then
	echo "Usage: run_demo <keyEntity> <distinguishedName>"
	echo "Press a key to exit"
	read
	exit
fi

DEMODIR="$(dirname "$(dirname "$(readlink -f "$0")")")"
DATADIR="$DEMODIR/data"
APIDIR="$(dirname "$(dirname "$DEMODIR")")/dev"

CLASSPATH="$DEMODIR/lib/*:$APIDIR/lib/*:$APIDIR/lib3rd/*"

HOST=localhost
PORT=8080
SERVICEPATH=/ais

JAVA=java

read -n1 -r -p $'Press a key to start SigningClient...\n'
"$JAVA" -cp "$CLASSPATH" de.intarsys.stage.security.device.ais.demo.AisSignatureClient "$1" "$2" "$DATADIR/doc_unsigned.pdf" "$HOME/doc_unsigned.result.pdf" $HOST $SERVICEPATH $PORT
echo Done.

read -n1 -r -p $'Press a key to end...\n'
