package de.intarsys.stage.security.device.ais.demo;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;

import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class AisSignatureClient {

	public static void main(String[] args) {
		try {
			new AisSignatureClient().run(args);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	protected String getArg(String[] args, int index, String defaultValue) {
		if (args.length > index) {
			return args[index];
		}
		return defaultValue;
	}

	public void run(String[] args) throws Exception {
		if (args.length < 2) {
			System.err.println("keyEntity and distiguishedName are required");
			return;
		}
		String keyEntity = args[0];
		String distinguishedName = args[1];
		String inName = getArg(args, 2, "../data/doc_unsigned.pdf");
		String outName = getArg(args, 3, System.getProperty("java.io.tmpdir") + "/data/doc_unsigned.result.pdf");
		String hostname = getArg(args, 4, "localhost");
		String servicename = getArg(args, 5, "/ais");
		int port = Integer.parseInt(getArg(args, 6, "8080"));
		//
		URL url = new URL("http", hostname, port, servicename);

		ByteArrayOutputStream byteArrayStream = new ByteArrayOutputStream();
		try (OutputStream base64Stream = Base64.getEncoder().wrap(byteArrayStream)) {
			Files.copy(Path.of(inName), base64Stream);
		}

		// prepare HTTP call
		try (CloseableHttpClient client = HttpClients.createDefault()) {
			HttpPost method = new HttpPost(url.toString());
			List<NameValuePair> nvps = new ArrayList<NameValuePair>();

			// add parameters
			nvps.add(new BasicNameValuePair("document.content", byteArrayStream.toString()));
			nvps.add(new BasicNameValuePair("document.name", inName));
			nvps.add(new BasicNameValuePair("digestSigner.args.keyEntity", keyEntity));
			nvps.add(new BasicNameValuePair("digestSigner.args.distinguishedName", distinguishedName));
			// optional parameters
			// digestSigner.args.stepUpLanguage
			// digestSigner.args.stepUpMessage
			// digestSigner.args.stepUpMSISDN

			UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvps, "UTF-8");
			method.setEntity(entity);

			// perform call
			try (CloseableHttpResponse response = client.execute(method)) {
				if (response.getStatusLine().getStatusCode() != HttpStatus.SC_OK) {
					// handle error
					System.out.println(EntityUtils.toString(response.getEntity()));
					return;
				}
				Path path = Path.of(outName);
				// will consume and close the response stream
				Files.copy(response.getEntity().getContent(), path);
				System.out.println("Signature file written to: " + path.toAbsolutePath());
			}
		}
	}
}
