package de.intarsys.signlive.demo.api.http.signature;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.stream.StreamTools;

public class SignatureClient {

	public static void main(String[] args) {
		try {
			new SignatureClient().run(args);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	protected String getArg(String[] args, int index, String defaultValue) {
		if (args.length > index) {
			return args[index];
		}
		return defaultValue;
	}

	public void run(String[] args) throws Exception {
		String inName = getArg(args, 0, "../data/doc_unsigned.pdf");
		String outName = getArg(args, 1, System.getProperty("java.io.tmpdir") + "/data/doc_unsigned.result.pdf");
		String hostname = getArg(args, 2, "localhost");
		String servicename = getArg(args, 3, "/demo/SignatureService");
		int port = Integer.parseInt(getArg(args, 4, "8080"));
		//
		URL url = new URL("http", hostname, port, servicename);
		HttpResponse response = null;
		try {
			// prepare HTTP call
			HttpClient client = new DefaultHttpClient();
			HttpPost method = new HttpPost(url.toString());
			List<NameValuePair> nvps = new ArrayList<NameValuePair>();

			FileInputStream filestream = new FileInputStream(inName);
			byte[] doc = StreamTools.toByteArray(filestream);
			String encodedDoc = new String(Base64.encode(doc));

			// add parameters
			nvps.add(new BasicNameValuePair("document.content", encodedDoc));
			nvps.add(new BasicNameValuePair("document.name", inName));

			UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvps, "UTF-8");
			method.setEntity(entity);

			// perform call
			response = client.execute(method);
			if (response.getStatusLine().getStatusCode() != HttpStatus.SC_OK) {
				// handle error
				return;
			}

			HttpEntity resultEntity = response.getEntity();
			InputStream is = null;
			OutputStream os = null;
			File out = new File(outName);
			try {
				is = resultEntity.getContent();
				os = new FileOutputStream(out);
				StreamTools.copyStream(is, false, os, false);
			} finally {
				StreamTools.close(is);
				StreamTools.close(os);
			}
			System.out.println("Signature file written to: " + out.getAbsolutePath());
		} finally {
			if (response != null && response.getEntity() != null) {
				response.getEntity().consumeContent();
			}
		}
	}
}
