/*
 * ijcontext.h
 *
 *  Created on: 17.12.2008
 *      Author: ehk
 */

#ifndef IJCONTEXT_H_
#define IJCONTEXT_H_

#include "jni.h"

#include "ijlauncher/config.h"
#include "ijlauncher.h"

#ifdef __cplusplus
extern "C"
{
#endif

typedef struct _ij_callbackinfo_t ij_callbackinfo_t;
typedef struct _ij_context_t ij_context_t;

struct _ij_callbackinfo_t
{
	char *name;
	void *address;
};

struct _ij_context_t
{
	void *handle;
	char *name;
	jobject peer;
	int error_code;
	ij_callbackinfo_t *callbacks;
};

ij_value_t IJLAUNCHER_API ij_context_call_method(ij_context_t *, const char *,
		const char *, ...);

void IJLAUNCHER_API ij_context_create(void *, ij_context_t **);

void IJLAUNCHER_API ij_context_destroy(ij_context_t *);

void IJLAUNCHER_API ij_context_env_activate(ij_context_t *, ij_env_t *);

ij_value_t IJLAUNCHER_API ij_context_env_call_method(ij_context_t *, ij_env_t *,
		const char *, const char *, ...);

ij_value_t IJLAUNCHER_API ij_context_env_call_method_args(ij_context_t *,
		ij_env_t *, const char *, const char *, va_list);

ij_env_t IJLAUNCHER_API *ij_context_env_create(ij_context_t *);

void IJLAUNCHER_API ij_context_env_deactivate(ij_context_t *, ij_env_t *);

void IJLAUNCHER_API ij_context_env_destroy(ij_context_t *, ij_env_t *);

jobject IJLAUNCHER_API ij_context_get_peer(ij_context_t *ij_context,
		ij_env_t *ij_env);

#ifdef __cplusplus
}
#endif

#endif /* IJCONTEXT_H_ */
