#ifndef IJLAUNCHER_H
#define IJLAUNCHER_H

#include <stdbool.h>
#include <stdint.h>
#include <wchar.h>

#include "jni.h"

#include "ijlauncher/config.h"

#ifdef __cplusplus
extern "C"
{
#endif

typedef enum _value_type_t value_type_t;

enum _value_type_t
{
	TYPE_VOID,
	TYPE_ERROR,
	TYPE_BOOL,
	TYPE_CHAR,
	TYPE_WCHAR,
	TYPE_STRING,
	TYPE_WSTRING,
	TYPE_INT2,
	TYPE_INT4,
	TYPE_INT8,
	TYPE_FLOAT4,
	TYPE_FLOAT8,
	TYPE_OBJECT_GLOBAL,
	TYPE_OBJECT_LOCAL
};

typedef struct _ij_env_t ij_env_t;
typedef struct _ij_value_t ij_value_t;

struct _ij_env_t
{
	JNIEnv *env;
	bool attached;
};

struct _ij_value_t
{
	value_type_t type;
	union _value
	{
		bool bool_value;
		char char_value;
		wchar_t wchar_value;
		const char *string_value;
		const wchar_t *wstring_value;
		short int2_value;
		int int4_value;
		int64_t int8_value;
		float float4_value;
		double float8_value;
		jobject object_global_value;
		jobject object_local_value;
	} value;
};

jobject IJLAUNCHER_API ij_call_constructor(ij_env_t *, const char *, const char *, ...);

ij_value_t IJLAUNCHER_API ij_call_method(ij_env_t *, jobject, const char *, const char*, ...);

ij_value_t IJLAUNCHER_API ij_call_method_args(ij_env_t *, jobject, const char *, const char*,
		va_list args);

ij_value_t IJLAUNCHER_API ij_call_static_method(ij_env_t *, const char *, const char *,
		const char*, ...);

ij_value_t IJLAUNCHER_API ij_call_static_method_args(ij_env_t *, const char *, const char *,
		const char*, va_list args);

jobject ij_conv_ijvalue_2_jobject(ij_env_t *, ij_value_t);

jobjectArray IJLAUNCHER_API ij_conv_ijvalue_2_jobject_array(ij_env_t *, int, ij_value_t *);

ij_value_t IJLAUNCHER_API ij_conv_jobject_2_ijvalue(ij_env_t *, jobject);

char IJLAUNCHER_API *ij_conv_jstring_2_pchar(ij_env_t *, jstring);

wchar_t *ij_conv_jstring_2_pwchar(ij_env_t *, jstring);

ij_value_t IJLAUNCHER_API  ij_conv_jvalue_2_ijvalue(ij_env_t *, jvalue, const char *);

jstring IJLAUNCHER_API ij_conv_pchar_2_jstring(ij_env_t *, const char *);

jstring IJLAUNCHER_API ij_conv_pwchar_2_jstring(ij_env_t *, const wchar_t *);

jobject IJLAUNCHER_API ij_create_global(ij_env_t *, jobject, bool);

jobject ij_create_java_context();

void IJLAUNCHER_API ij_destroy_global(jobject);

void IJLAUNCHER_API ij_destroy_local(ij_env_t *, jobject);
#define ij_destroy_string(x ,y) ij_destroy_local(x, y);

void IJLAUNCHER_API ij_destroy_value(ij_env_t *, ij_value_t);

void IJLAUNCHER_API ij_ensure_global(ij_env_t *ij_env, ij_value_t *ij_value);

ij_env_t IJLAUNCHER_API *ij_env_create();

void IJLAUNCHER_API ij_env_destroy(ij_env_t *);

#ifdef __cplusplus
}
#endif

#endif /* IJLAUNCHER_H */
