/*
 * CABAReT solutions
 * all rights reserved
 *
 */
package com.cabaret.demo.embedded.java;

import com.cabaret.claptz.stage.main.CommonStage;

import de.intarsys.claptz.launcher.SingletonContainerLauncher;
import de.intarsys.tools.environment.file.StandardFileEnvironment;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;

/**
 * This example shows a simple AWT host, launching and controlling the SWT
 * interactive application. The SWT part is running in a dedicated thread. This
 * example may be defunct on non-windows platforms.
 */
public class DemoHostedAWTDedicatedThread extends DemoHostedAWT {

	public static void main(String[] args) {
		new DemoHostedAWTDedicatedThread().run();
	}

	protected void launchContainer() throws Exception {
		IArgs args = Args.create();
		StandardFileEnvironment fileEnvironment = new StandardFileEnvironment("c:/NoInstall/Sign Live CC 6.4",
				"c:/temp/mystage");
		args.put("fileEnvironment", fileEnvironment);
		args.put("container", CommonStage.class);
		args.put("itDirs", System.getProperty("user.dir") + "/deploy/sdk/Java/demo/HelloWorld");
		SingletonContainerLauncher.get().launch(args);
	}

	public void run() {
		createView();
		Thread guiThread = new Thread(new Runnable() {
			@Override
			public void run() {
				// launch stage in a dedicated thread, thereby making it the SWT
				// GUI
				// thread. in this example this is a blocking call, dispatching
				// the GUI
				// internally
				setStateText("launching...");
				try {
					launchContainer();
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}, "GUI thread");
		guiThread.start();
		// main will terminate now
	}

}
