/*
 * CABAReT solutions
 * all rights reserved
 *
 */
package com.cabaret.demo.embedded.java;

import java.awt.Button;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.BoxLayout;

import de.intarsys.claptz.launcher.SingletonContainerLauncher;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;

/**
 * This is an application of "hosted" mode. You have an application of your own
 * and want to include processing features from an headless claptz container.
 * The "two" applications will run side by side.
 * <p>
 * Attention: Do not forget to provide a professional license - this is needed
 * by headless mode.
 * 
 * The subclasses implement concrete embedding scenarios.
 */
abstract public class DemoHostedHeadless {

	protected Frame frame;

	protected Label stateLabel;

	protected void createView() {
		frame = new Frame("My application");
		frame.setSize(450, 250);
		frame.addWindowListener(new WindowAdapter() {
			@Override
			public void windowClosing(WindowEvent e) {
				shutdown();
				System.exit(0);
			}
		});
		frame.setLayout(new BoxLayout(frame, BoxLayout.Y_AXIS));
		Panel content = new Panel();
		content.setLayout(new FlowLayout());
		frame.add(content);
		Label label = new Label("application state:");
		frame.add(label);
		stateLabel = new Label("undefined");
		frame.add(stateLabel);
		Panel buttons = new Panel();
		buttons.setLayout(new BoxLayout(buttons, BoxLayout.X_AXIS));
		frame.add(buttons);
		//
		Button btnPerform = new Button(getButtonLabel());
		btnPerform.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent e) {
				onPerform();
			}
		});
		buttons.add(btnPerform);
		frame.setVisible(true);
	}

	abstract protected String getButtonLabel();

	protected ILocator getLocatorLoad(String title) {
		FileDialog dialog = new FileDialog(frame, title, FileDialog.LOAD);
		try {
			dialog.setVisible(true);
			String filename = dialog.getFile();
			if (filename != null) {
				return new FileLocator(dialog.getDirectory() + "/" + filename);
			}
			return null;
		} finally {
			dialog.dispose();
		}
	}

	protected ILocator getLocatorSave(String title) {
		FileDialog dialog = new FileDialog(frame, title, FileDialog.SAVE);
		try {
			dialog.setVisible(true);
			String filename = dialog.getFile();
			if (filename != null) {
				return new FileLocator(dialog.getDirectory() + "/" + filename);
			}
			return null;
		} finally {
			dialog.dispose();
		}
	}

	abstract protected void onPerform();

	protected void setStateText(String text) {
		stateLabel.setText(text);
	}

	protected void shutdown() {
		SingletonContainerLauncher.get().release();
	}
}
