/*
 * CABAReT solutions
 * all rights reserved
 *
 */
package com.cabaret.demo.embedded.java;

import com.cabaret.api.java.JavaAPITools;
import com.cabaret.claptz.stage.main.CommonStage;

import de.intarsys.claptz.launcher.SingletonContainerLauncher;
import de.intarsys.tools.environment.file.StandardFileEnvironment;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.MethodException;

/**
 * A sample headless integration scenario.
 * 
 */
public class DemoHostedHeadlessGenericAPI extends DemoHostedHeadless {

	public static void main(String[] args) {
		new DemoHostedHeadlessGenericAPI().run();
	}

	@Override
	protected String getButtonLabel() {
		return "Call 'hello'";
	}

	protected void launchContainer() throws Exception {
		IArgs args = Args.create();
		StandardFileEnvironment fileEnvironment = new StandardFileEnvironment("c:/NoInstall/Sign Live CC 6.4",
				"c:/temp/mystage");
		args.put("fileEnvironment", fileEnvironment);
		args.put("container", CommonStage.class);
		args.put("define", "appless");
		args.put("itDirs", System.getProperty("user.dir") + "/deploy/sdk/Java/demo/HelloWorld");
		SingletonContainerLauncher.get().launch(args);
	}

	@Override
	protected void onPerform() {
		try {
			setStateText("calling...");
			JavaAPITools.call("hello");
			setStateText("called");
		} catch (MethodException e) {
			setStateText("call failed");
			e.printStackTrace();
		}
	}

	public void run() {
		createView();
		setStateText("launching...");
		try {
			launchContainer();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
