/*
 * CABAReT solutions
 * all rights reserved
 *
 */
package com.cabaret.demo.embedded.java;

import com.cabaret.claptz.stage.main.CommonStage;

import de.intarsys.claptz.launcher.SingletonContainerLauncher;
import de.intarsys.document.model.IDocument;
import de.intarsys.tools.environment.file.StandardFileEnvironment;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.FunctorTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ILocator;

public class DemoHostedHeadlessResident extends DemoHostedHeadless {

	public static void main(String[] args) {
		new DemoHostedHeadlessResident().run();
	}

	@Override
	protected String getButtonLabel() {
		return "Import HTML";
	}

	protected void launchContainer() throws Exception {
		IArgs args = Args.create();
		StandardFileEnvironment fileEnvironment = new StandardFileEnvironment("c:/NoInstall/Sign Live CC 6.4",
				"c:/temp/mystage");
		args.put("fileEnvironment", fileEnvironment);
		args.put("container", CommonStage.class);
		args.put("define", "appless");
		SingletonContainerLauncher.get().launch(args);
	}

	@Override
	protected void onPerform() {
		ILocator locatorLoad = getLocatorLoad("Import HTML");
		if (locatorLoad == null) {
			return;
		}
		IDocument idoc = null;
		try {
			setStateText("importing " + locatorLoad.getFullName() + "...");
			Args importArgs = Args.create();
			importArgs.put("importLocator", locatorLoad);
			idoc = (IDocument) FunctorTools.perform("com.cabaret.pdf.exchange.html.HTMLImporterFactory", importArgs);
			setStateText("imported " + locatorLoad.getFullName() + "");
			ILocator locatorSave = getLocatorSave("Save PDF");
			if (locatorSave == null) {
				return;
			}
			Args saveArgs = Args.create();
			saveArgs.put(IDocument.ARG_LOCATOR, locatorSave);
			idoc.invoke(IDocument.METHOD_SAVE, saveArgs);
			setStateText("saved " + locatorSave.getFullName() + "");
		} catch (Exception e) {
			setStateText("failed");
			e.printStackTrace();
		} finally {
			if (idoc != null) {
				idoc.release(null);
			}
		}

	}

	public void run() {
		createView();
		setStateText("launching...");
		try {
			launchContainer();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
