#include <stdio.h>
#include <stdlib.h>

#include "stagesl.h"

int main(int argc, char *argv[])
{
	ij_value_t *args;
	int index;
	ij_value_t result;

	if (argc < 2)
	{
		printf("Usage: stagesltest <method> [arguments]\n");
		return 0;
	}

	printf("Launching Stage. Press ENTER to continue ...\n");
	getchar();
	result = launch("-launch headless noblock resident");
	if (result.type == TYPE_ERROR)
	{
		printf("Error launching Stage. Check system log.\n");
		goto leave;
	}
	else if (result.value.int4_value != 0)
	{
		printf("Error launching Stage. Check log.\n");
		goto leave;
	}

	printf("Calling method. Press ENTER to continue ...\n");
	getchar();
	args = malloc(sizeof(ij_value_t) * (argc - 2));
	for (index = 0; index < argc - 2; index++)
	{
		args[index].type = TYPE_STRING;
		args[index].value.string_value = argv[index + 2];
	}
	result = synchCallArgs(argv[1], argc - 2, args);
	if (result.type == TYPE_ERROR)
	{
		printf("Error calling method. Check system log.\n");
	}
	free(args);
	destroyValue(result);

	printf("Shutting down. Press ENTER to continue ...\n");
	getchar();
	shutdown();

	leave: printf("Exiting. Press ENTER to continue ...\n");
	getchar();
	return 0;
}
