
// TESTAPPDlg.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "TESTAPP.h"
#include "TESTAPPDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

INT CALLBACK BrowseCallbackProc(HWND hwnd, 
                                UINT uMsg,
                                LPARAM lp, 
                                LPARAM pData) 
{
   TCHAR szDir[MAX_PATH];

   switch(uMsg) 
   {
   case BFFM_INITIALIZED: 
      if (pData)
      {
          LPCTSTR lpszDefaultDir = (LPCTSTR)pData;
          if (lpszDefaultDir)
              _tcscpy_s (szDir, MAX_PATH, lpszDefaultDir);
          else
              GetCurrentDirectory(sizeof(szDir)/sizeof(TCHAR), szDir);
      
         // WParam is TRUE since you are passing a path.
         // It would be FALSE if you were passing a pidl.
         SendMessage(hwnd, BFFM_SETSELECTION, TRUE, (LPARAM)szDir);
      }
      break;

   case BFFM_SELCHANGED: 
      // Set the status window to the currently selected path.
      if (SHGetPathFromIDList((LPITEMIDLIST) lp ,szDir))
      {
         SendMessage(hwnd,BFFM_SETSTATUSTEXT,0,(LPARAM)szDir);
      }
      break;
   }
   return 0;
}


// CTESTAPPDlg-Dialogfeld



CTESTAPPDlg::CTESTAPPDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_TESTAPP_DIALOG, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

	m_iSignatureOption = 0;

	memset (m_szPDFFileName, 0x0, sizeof (m_szPDFFileName));
	memset (m_szFolder, 0x0, sizeof (m_szFolder));
}

void CTESTAPPDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Radio (pDX, IDC_RB_SINGLE_SIGNATURE, m_iSignatureOption);
	DDX_Control(pDX, IDC_ED_PDFFILE, m_CEditPDFFile);
	DDX_Control(pDX, IDC_ED_FOLDER, m_CEditFolder);
	DDX_Control(pDX, IDC_PB_SELECT_FILE, m_PBtnSelectPDFFile);
	DDX_Control(pDX, IDC_PB_SELECT_FOLDER, m_PBtnSelectFolder);

}

BEGIN_MESSAGE_MAP(CTESTAPPDlg, CDialogEx)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED (IDC_RB_SINGLE_SIGNATURE, OnRadiobuttonPDFFile)
	ON_BN_CLICKED (IDC_RB_MULTI_SIGNATURE_FOLDER, OnRadiobuttonFolder)
	ON_BN_CLICKED (IDC_PB_SELECT_FILE, OnButtonSelectPDFFile)
	ON_BN_CLICKED (IDC_PB_SELECT_FOLDER, OnButtonSelectFolder)

END_MESSAGE_MAP()


// CTESTAPPDlg-Meldungshandler

BOOL CTESTAPPDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	// Symbol fr dieses Dialogfeld festlegen.  Wird automatisch erledigt
	//  wenn das Hauptfenster der Anwendung kein Dialogfeld ist
	SetIcon(m_hIcon, TRUE);			// Groes Symbol verwenden
	SetIcon(m_hIcon, FALSE);		// Kleines Symbol verwenden

	// TODO: Hier zustzliche Initialisierung einfgen
	m_PBtnSelectFolder.EnableWindow (FALSE);

	LoadLibrary(_T("ijlauncher.dll"));
	DWORD test = GetLastError();
	HMODULE hModule = LoadLibrary(_T("stageci.dll"));
	test = GetLastError();
	m_destroyValue = (destroyValue_t)GetProcAddress(hModule, "destroyValue");
	m_launch = (launch_t)GetProcAddress(hModule, "launch");
	m_shutdown = (shutdown_t)GetProcAddress(hModule, "shutdown");
	m_synchCallArgs = (synchCallArgs_t)GetProcAddress(hModule, "synchCallArgs");

	ij_value_t result = m_launch("-launch interactive noblock resident -nowakeonstart -itdirs c:\\temp\\external\\instruments");
	if (result.type != TYPE_INT4)
		throw;
	if (result.value.int4_value != 0)
		throw;
	
	return TRUE;  // TRUE zurckgeben, wenn der Fokus nicht auf ein Steuerelement gesetzt wird
}

// Wenn Sie dem Dialogfeld eine Schaltflche "Minimieren" hinzufgen, bentigen Sie
//  den nachstehenden Code, um das Symbol zu zeichnen.  Fr MFC-Anwendungen, die das 
//  Dokument/Ansicht-Modell verwenden, wird dies automatisch ausgefhrt.

void CTESTAPPDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // Gertekontext zum Zeichnen

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Symbol in Clientrechteck zentrieren
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Symbol zeichnen
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

// Die System ruft diese Funktion auf, um den Cursor abzufragen, der angezeigt wird, whrend der Benutzer
//  das minimierte Fenster mit der Maus zieht.
HCURSOR CTESTAPPDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CTESTAPPDlg :: OnRadiobuttonPDFFile () 
{
	m_iSignatureOption = 0;
	m_PBtnSelectPDFFile.EnableWindow ();
	m_PBtnSelectFolder.EnableWindow (FALSE);
} // CTESTAPPDlg :: OnRadiobuttonPDFFile

void CTESTAPPDlg :: OnRadiobuttonFolder()
{
	m_iSignatureOption = 1;
	m_PBtnSelectPDFFile.EnableWindow (FALSE);
	m_PBtnSelectFolder.EnableWindow ();
} // CTESTAPPDlg :: OnRadiobuttonFolder

void CTESTAPPDlg :: OnButtonSelectPDFFile ()
{
	CString cstrExtension(".PDF");
	CString cstrSelFullPathName("");
	CString cstrFilter("");

	cstrFilter = _T("PDF-Datei (*.pdf)|*.pdf||");

	CFileDialog	dlg(TRUE, // bOpenFileDialog,
		cstrExtension,	// lpszDefExt
		cstrSelFullPathName, // lpszFileName
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, // dwFlags
		cstrFilter,	// lpszFilter
		NULL);	// pParentWnd		

		if (dlg.DoModal() == IDOK)
		{
			_tcsncpy_s (m_szPDFFileName, dlg.GetPathName (), _TRUNCATE);
			m_CEditPDFFile.SetWindowText (m_szPDFFileName);
		}

} // CTESTAPPDlg :: OnButtonSelectPDFFile

void CTESTAPPDlg :: OnButtonSelectFolder ()
{
    BROWSEINFO bi;
    ZeroMemory(&bi,sizeof(bi));
    bi.hwndOwner = m_hWnd;
    bi.pidlRoot = NULL;

    bi.lpszTitle = _T("Verzeichnis auswhlen");
    bi.ulFlags = BIF_USENEWUI | BIF_NONEWFOLDERBUTTON;

    bi.lpfn = BrowseCallbackProc;
    bi.lParam = NULL;
    
    LPITEMIDLIST pidl;

    pidl = SHBrowseForFolder(&bi);
    if (pidl &&
        ::SHGetPathFromIDList(pidl, m_szFolder))
    {
		m_CEditFolder.SetWindowText (m_szFolder);
    }
	else
	{
		memset (m_szFolder, 0x0, sizeof (m_szFolder));
		m_CEditFolder.SetWindowText (m_szFolder);
	}
} // CTESTAPPDlg :: OnButtonSelectFolder


void CTESTAPPDlg :: OnOK ()
{
	if (m_iSignatureOption == 0)
	{
		CString string;
		string.Format(_T("document.path=%s;documentSigner.factory=com.cabaret.security.method.pdf.signing.PDFDocumentSignerFactory;documentSigner.args.digestSigner.factory=de.intarsys.stage.security.device.smartcard.signature.SmartcardDigestSigner;documentSigner.args.digestSigner.args.signerSelectionInteractive=true;documentSigner.args.digestSigner.args.signerIdentifier=usage=qualified_signature;"), m_szPDFFileName);

		ij_value_t args[1];
#ifdef UNICODE
		args[0].type = TYPE_WSTRING;
		args[0].value.wstring_value = string.GetBuffer(string.GetLength());
#else
		args[0].type = TYPE_STRING;
		args[0].value.string_value = string.GetBuffer(string.GetLength());
#endif
		ij_value_t result = m_synchCallArgs("//external/functor/com.cabaret.security.document.signing.MultiSignerFactory", 1, args);
		if (result.type == TYPE_ERROR)
			throw;
		m_destroyValue(result);
	}
	else
	{
		CString string;
		string.Format(_T("documentFolder.path=%s;documentPattern=.*\\.pdf;documentSigner.factory=com.cabaret.security.method.pdf.signing.PDFDocumentSignerFactory;documentSigner.args.digestSigner.factory=de.intarsys.stage.security.device.smartcard.signature.SmartcardDigestSigner;documentSigner.args.digestSigner.args.signerSelectionInteractive=true;documentSigner.args.digestSigner.args.signerIdentifier=usage=qualified_signature;"), m_szFolder);

		ij_value_t args[1];
#ifdef UNICODE
		args[0].type = TYPE_WSTRING;
		args[0].value.wstring_value = string.GetBuffer(string.GetLength());
#else
		args[0].type = TYPE_STRING;
		args[0].value.string_value = string.GetBuffer(string.GetLength());
#endif
		ij_value_t result = m_synchCallArgs("//external/functor/com.cabaret.security.document.signing.MultiSignerFactory", 1, args);
		string.ReleaseBuffer();
		if (result.type == TYPE_ERROR)
			throw;
		m_destroyValue(result);
	}

	// m_shutdown();
	// EndDialog (IDOK);
} // CTESTAPPDlg :: OnOK