#include <stdio.h>
#include <stdlib.h>

#include "stagesl.h"

int main(int argc, char *argv[])
{
	ij_value_t args[1];
	int index;
	ij_value_t result;

	result = launch("-launch interactive noblock resident -nowakeonstart -itdirs c:\temp\external\instruments");
	if (result.type == TYPE_ERROR)
	{
		printf("Error launching Stage. Check system log.\n");
		return -1;
	}
	else if (result.value.int4_value != 0)
	{
		printf("Error launching Stage. Check log.\n");
		return -1;
	} 
 
 	/**
 	* single document signature
 	**/
	args[0].type = TYPE_STRING;
	args[0].value.string_value = "document.path=c:/temp/external/tags.pdf;documentSigner.factory=com.cabaret.security.method.pdf.signing.PDFDocumentSignerFactory;documentSigner.args.digestSigner.factory=de.intarsys.stage.security.device.smartcard.signature.SmartcardDigestSigner;documentSigner.args.digestSigner.args.signerSelectionInteractive=true;documentSigner.args.digestSigner.args.signerIdentifier=usage=qualified_signature;";
	result = synchCallArgs("//external/functor/com.cabaret.security.document.signing.MultiSignerFactory", 1, args);
	if (result.type == TYPE_ERROR)
	{
		return -1;
	} 
 
 	/**
 	* multi document signature
 	**/
	args[0].type = TYPE_STRING;
	args[0].value.string_value = "documents.0.path=c:/temp/external/tags.pdf;documents.1.path=c:/temp/external/tags.pdf;documentSigner.factory=com.cabaret.security.method.pdf.signing.PDFDocumentSignerFactory;documentSigner.args.digestSigner.factory=de.intarsys.stage.security.device.smartcard.signature.SmartcardDigestSigner;documentSigner.args.digestSigner.args.signerSelectionInteractive=true;documentSigner.args.digestSigner.args.signerIdentifier=usage=qualified_signature;";
	result = synchCallArgs("//external/functor/com.cabaret.security.document.signing.MultiSignerFactory", 1, args);
	if (result.type == TYPE_ERROR)
	{
		return -1;
	} 
 
 	/**
 	* folder signature
 	**/
	args[0].type = TYPE_STRING;
	args[0].value.string_value = "documentFolder.path=c:/temp/external;documentPattern=.*\.pdf;documentSigner.factory=com.cabaret.security.method.pdf.signing.PDFDocumentSignerFactory;documentSigner.args.digestSigner.factory=de.intarsys.stage.security.device.smartcard.signature.SmartcardDigestSigner;documentSigner.args.digestSigner.args.signerSelectionInteractive=true;documentSigner.args.digestSigner.args.signerIdentifier=usage=qualified_signature;";
	result = synchCallArgs("//external/functor/com.cabaret.security.document.signing.MultiSignerFactory", 1, args);
	if (result.type == TYPE_ERROR)
	{
		return -1;
	} 
 
	destroyValue(result);
	shutdown();
	return 0;
}
