/*
 * CABAReT solutions
 * all rights reserved
 *
 */
package com.cabaret.demo.api.webservice.helloworld;

import java.net.URL;

import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;

import com.cabaret.api.webservice.CallService;

import de.intarsys.web.service.api.ServiceException;
import de.intarsys.web.service.common.Map;

public class DemoApiWebServiceJavaScript {

	public static void main(String[] args) {
		try {
			String hostname = "localhost";
			String servicename = "/HelloJavaScript";
			int port = 8080;
			if (args.length > 0) {
				hostname = args[0];
			}
			if (args.length > 1) {
				port = Integer.parseInt(args[1]);
			}
			if (args.length > 2) {
				servicename = args[2];
			}
			JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
			factory.getInInterceptors().add(new LoggingInInterceptor());
			factory.getOutInterceptors().add(new LoggingOutInterceptor());
			factory.setServiceClass(CallService.class);
			factory.setAddress(new URL("http", hostname, port, servicename).toExternalForm());
			CallService client = (CallService) factory.create();
			Map serviceArgs = new Map();
			serviceArgs.put("user", "Mr. X");
			try {
				String result = (String) client.callArgs("hello", serviceArgs);
				System.out.println("The server says: '" + result + "'");
			} catch (ServiceException e) {
				e.printStackTrace();
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
