package de.intarsys.signlive.demo.api.webservice.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;

import org.apache.cxf.interceptor.LoggingInInterceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;

import com.cabaret.api.webservice.CallService;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.web.service.api.ServiceException;
import de.intarsys.web.service.common.Map;

public class SignatureValidationClient {

	@SuppressWarnings("nls")
	public static void main(String[] args) {
		try {
			String inName = "../data/doc_signed.pdf";
			String outName = System.getProperty("java.io.tmpdir")
					+ "/data/doc_signed.report.pdf";
			String hostname = "localhost";
			String servicename = "/demo/SignatureValidationService";
			int port = 8080;
			if (args.length > 0) {
				inName = args[0];
			}
			if (args.length > 1) {
				outName = args[1];
			}
			if (args.length > 2) {
				hostname = args[2];
			}
			if (args.length > 3) {
				port = Integer.parseInt(args[3]);
			}
			if (args.length > 4) {
				servicename = args[4];
			}
			JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
			factory.getInInterceptors().add(new LoggingInInterceptor());
			factory.getOutInterceptors().add(new LoggingOutInterceptor());
			factory.setServiceClass(CallService.class);
			factory.setAddress(new URL("http", hostname, port, servicename)
					.toExternalForm());
			CallService client = (CallService) factory.create();

			FileInputStream filestream = new FileInputStream(inName);
			byte[] doc = StreamTools.toByteArray(filestream);

			Map serviceArgs = new Map();
			serviceArgs.put("document.content", doc); //$NON-NLS-1$
			serviceArgs.put("document.name", inName); //$NON-NLS-1$

			String signatureName = inName + ".p7s";
			if (new File(signatureName).isFile()) {
				FileInputStream signatureFilestream = new FileInputStream(
						signatureName);
				byte[] signatureDoc = StreamTools
						.toByteArray(signatureFilestream);
				Map signatureContainer = new Map();
				signatureContainer.put("content", signatureDoc); //$NON-NLS-1$
				signatureContainer.put("name", signatureName); //$NON-NLS-1$
				Map signatureContainers = new Map();
				signatureContainers.add(signatureContainer);
				serviceArgs.put("signatureContainers", signatureContainers); //$NON-NLS-1$
			}

			Map result = (Map) client.callArgs("validate", serviceArgs);
			int state = ((Number) result.get("state")).intValue();
			String stateString;
			switch (state) {
			case 0:
				stateString = "valid";
				break;
			case 2:
				stateString = "unknown";
				break;
			case 3:
				stateString = "invalid";
				break;
			default:
				stateString = "undefined";
				break;
			}
			System.out.println("Doument validated successfully. State is: "
					+ stateString);
			Map report = (Map) result.get("report");
			if (report != null) {
				byte[] resultContent = (byte[]) report.get("content");
				File out = new File(outName);
				FileTools.write(out, resultContent);
				System.out.println("Validation report written to: "
						+ out.getAbsolutePath());
			}
		} catch (IOException e) {
			e.printStackTrace();
		} catch (ServiceException e) {
			e.printStackTrace();
		}
	}
}
