#!/bin/sh
#
# This script searches for a java binary to run the installer jar file with.
# If you have a custom installation please set the $JAVA_HOME environment
# variable or set any links in your PATH environment variable.
#
# If $JAVA_HOME is set, this script will use ist. If not, it will search for
# a java binary in your path and, if not found, in your /usr/lib for a sun or
# ibm 1.5 java installation.
# 
# This script was written for Archisoft, (c) bei Fraunhofer SIT
# by Paul Wellner Bou
#

REQUIRED_VERSION="1.5"
JAR_FILE_TO_RUN="./archisoft-installer_1.1.1.10_20220228.jar"

# The first existing directory is used for JAVA_HOME (if JAVA_HOME is not defined)
JDK_DIRS="/usr/lib/jvm/java-1.5.0-sun /usr/lib/j2sdk1.5-sun /usr/lib/j2sdk1.5-ibm"

# Look for the right JVM to use
for jdir in $JDK_DIRS; do
	if [ -r "$jdir/bin/java" -a -z "${JAVA_HOME}" ]; then
		JAVA_HOME_TMP="$jdir"
	fi
done

if [ -z `which java` -a -z "${JAVA_HOME}" ]; then
	JAVA_EXE="$JAVA_HOME_TMP/bin/java"
else
	JAVA_EXE=`which java`
fi

JAVA_VERSION=`"$JAVA_EXE" -version 2>&1 | grep "java version \"${REQUIRED_VERSION}."`
if [ -z "${JAVA_VERSION}" ]; then
	echo "No suitable version of Java found. If you have version 1.5 or later installed, set your JAVA_HOME environment variable."
	exit 1;
fi;

# It looks like the default heap size of 64M is not enough for most cases
# se the maximum heap size is set to 128M
if [ -z "$JAVA_OPTS" ]; then
	JAVA_OPTS="-Xmx128M"
fi

"$JAVA_EXE" "$JAVA_OPTS" "-jar" "${JAR_FILE_TO_RUN}"
exit 0;
