/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.demo.auth;

import java.util.Map;

import org.apache.cxf.rs.security.jose.jwt.JwtToken;

import de.intarsys.tools.functor.IArgs;

public class OpenIdConnectPrincipal extends DemoPrincipal {

	public static String getLabel(JwtToken jwtToken) {
		StringBuilder sb = new StringBuilder();
		Object value = null;
		value = jwtToken.getClaim("name");
		if (value != null) {
			sb.append(value);
		} else {
			value = jwtToken.getClaim("email");
			if (value != null) {
				sb.append(value);
			} else {
				value = jwtToken.getClaim("given_name");
				if (value != null) {
					sb.append(value);
					sb.append(" ");
				}
				value = jwtToken.getClaim("fammily_name");
				if (value != null) {
					sb.append(value);
				}
				if (sb.length() == 0) {
					sb.append("<unknown>");
				}
			}
		}
		return sb.toString();
	}

	private final JwtToken jwtToken;

	private final String idToken;

	public OpenIdConnectPrincipal(JwtToken jwtToken, String idToken) {
		super(getLabel(jwtToken));
		this.jwtToken = jwtToken;
		this.idToken = idToken;
	}

	@Override
	public Map<String, Object> getClaims() {
		return jwtToken.getClaims().asMap();
	}

	public String getIdToken() {
		return idToken;
	}

	public JwtToken getJwtToken() {
		return jwtToken;
	}

	@Override
	public IArgs toArgs() {
		IArgs args = super.toArgs();
		jwtToken.getClaims().asMap().entrySet().stream()
				.forEach(entry -> args.put(entry.getKey(), String.valueOf(entry.getValue())));
		if (jwtToken.getClaim("name") == null) {
			args.put("name", getLabel(jwtToken));
		}
		return args;
	}

}
