/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.demo.auth;

import javax.security.auth.Subject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;

import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jaxrs.JaxrsTools;
import de.intarsys.tools.string.StringTools;

public class UserPasswordContext extends CommonAuthContext {

	private static final String PATH_APP_PREFIX = "/ng";

	private static final String PATH_LOGON = "/logon";

	private String username;

	private String password;

	public UserPasswordContext(CommonAuthModule authModule, Subject subject, IArgs args) {
		super(authModule, subject, args);
	}

	@Override
	public String authCallback(HttpServletRequest servletRequest) throws AuthenticationException {
		if (StringTools.isEmpty(username)) {
			throw new AuthenticationCanceled("authentication canceled");
		}
		/*
		 * we should store password in subject credentials in real life
		 */
		UserPasswordPrincipal principal = new UserPasswordPrincipal(username, password);
		getSubject().getPrincipals().add(principal);
		return principal.getToken();
	}

	@Override
	protected Response basicAuthenticate(HttpServletRequest servletRequest) throws AuthenticationException {
		/*
		 * try to derive a ui address. Our demo is expected to contain a "logon" ui.
		 */
		String urlCallback = servletRequest.getParameter("auth_callback");
		UriBuilder builder = null;
		if (!StringTools.isEmpty(urlCallback)) {
			int index = urlCallback.indexOf("/app");
			if (index > 0) {
				String urlContext = urlCallback.substring(0, index);
				builder = UriBuilder.fromUri(urlContext);
			}
		}
		if (builder == null) {
			builder = JaxrsTools.getUriBuilderContext(servletRequest);
			builder = builder.path(PATH_APP_PREFIX);
		}
		builder = builder.path(PATH_LOGON);
		return Response.temporaryRedirect(builder.build()).build();
	}

	@Override
	protected void basicDeauthenticate() {
		getSubject().getPrincipals().removeIf((principal) -> principal instanceof UserPasswordPrincipal);
	}

	public void logon(String username, String password) {
		/*
		 * currently we have no check implemented.
		 * 
		 * feel free to attach your favorite backend (DB, LDAP,..)
		 */
		this.username = username;
		this.password = password;
	}

}
