package de.intarsys.cloudsuite.gears.demo.config;

import java.util.Collections;
import java.util.List;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class CorsConfig implements WebMvcConfigurer {

	@Value("${security.cors.allowedHeaders:*}")
	private List<String> allowedHeaders;

	@Value("${security.cors.allowedMethods:*}")
	private List<String> allowedMethods;

	@Value("${security.cors.allowedOrigins:}")
	private List<String> allowedOrigins;

	@Value("${security.cors.allowedOriginPatterns:*}")
	private List<String> allowedOriginPatterns;

	@Value("${security.cors.exposedHeaders:Content-Disposition}")
	private List<String> exposedHeaders;

	@Value("${security.cors.allowCredentials:true}")
	private Boolean allowCredentials;

	/**
	 * We need to low-level register CORS filter as the {@link CorsRegistry}
	 * initiated one is only in the spring servlet chain, not in the Jersey one.
	 * 
	 * @return
	 */
	@Bean
	public FilterRegistrationBean<CorsFilter> cors() {
		CorsConfiguration config = new CorsConfiguration();
		config.setAllowedHeaders(allowedHeaders);
		config.setAllowedMethods(allowedMethods);
		config.setAllowedOrigins(allowedOrigins);
		config.setAllowedOriginPatterns(allowedOriginPatterns);
		config.setAllowCredentials(allowCredentials);
		config.setExposedHeaders(exposedHeaders);
		UrlBasedCorsConfigurationSource configSource = new UrlBasedCorsConfigurationSource();
		configSource.registerCorsConfiguration("/**", config);
		CorsFilter filter = new CorsFilter(configSource);
		FilterRegistrationBean<CorsFilter> registration = new FilterRegistrationBean<CorsFilter>();
		registration.setFilter(filter);
		registration.setUrlPatterns(Collections.singletonList("/*"));
		registration.setName("cors");
		return registration;
	}
}