/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.demo.jaxrs;

import java.security.Principal;

import jakarta.ws.rs.core.SecurityContext;

public class DemoSecurityContext implements SecurityContext {

	private final Principal principal;

	private final String authenticationScheme;

	private final boolean secure;

	public DemoSecurityContext(Principal principal, String authenticationScheme, boolean secure) {
		super();
		this.principal = principal;
		this.authenticationScheme = authenticationScheme;
		this.secure = secure;
	}

	@Override
	public String getAuthenticationScheme() {
		return authenticationScheme;
	}

	@Override
	public Principal getUserPrincipal() {
		return principal;
	}

	@Override
	public boolean isSecure() {
		return secure;
	}

	@Override
	public boolean isUserInRole(String role) {
		return false;
	}

}
