package de.intarsys.cloudsuite.gears.demo.model;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

import jakarta.ws.rs.client.Invocation.Builder;

public class BasicAuthModifier extends CallModifier {

	private final String user;

	private final String password;

	public BasicAuthModifier(String user, String password) {
		super();
		this.user = user;
		this.password = password;
	}

	@Override
	public void accept(Builder builder, URI target) {
		builder.header("Authorization", "Basic " + createBasicToken(user, new String(password)));
	}

	protected String createBasicToken(String user, String password) {
		return Base64.getEncoder().encodeToString((user + ":" + password).getBytes(StandardCharsets.ISO_8859_1));
	}
}
