/*
 *   o_
 * in|tarsys GmbH (c)
 *
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.demo.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import jakarta.annotation.PostConstruct;

import org.springframework.stereotype.Component;
import org.springframework.web.context.annotation.ApplicationScope;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;

import de.intarsys.cloudsuite.gears.core.service.common.api.DtoConfigurations;
import de.intarsys.tools.exception.InitializationException;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.string.StringTools;

@Component
@ApplicationScope
public class DemoUserStore {

	private static final String PATH_APP = ".cloudsuite-demo";

	private File rootDir;

	private ObjectMapper mapper;

	public DemoUserStore() {
		super();
	}

	protected File getBaseDir() {
		return new File(System.getProperty("user.home"));
	}

	public ObjectMapper getMapper() {
		return mapper;
	}

	public File getRootDir() {
		return rootDir;
	}

	public DemoUser getUser(String name) {
		return new DemoUser(this, name);
	}

	@PostConstruct
	public void init() {
		File baseDir = getBaseDir();
		rootDir = new File(baseDir, PATH_APP);
		try {
			FileTools.mkdirs(rootDir);
		} catch (IOException e) {
			throw new InitializationException(e);
		}
		mapper = JsonMapper
				.builder()
				.enable(JsonReadFeature.ALLOW_JAVA_COMMENTS)
				.enable(JsonReadFeature.ALLOW_SINGLE_QUOTES)
				.enable(JsonReadFeature.ALLOW_TRAILING_COMMA)
				.enable(JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES)
				.build();
	}

	public synchronized void load(DemoUser user, File userFile) throws IOException, JsonParseException,
			JsonMappingException,
			FileNotFoundException {
		List<DemoPreset> tmpPresets = new ArrayList<>();
		Map<String, String> tmpSettings = new HashMap<>();
		LinkedHashMap<String, DemoDoc> tmpDocuments = new LinkedHashMap<>();
		DtoConfigurations tmpConfigurations = null;
		String tmpPresetId = "default";
		try (InputStream is = new FileInputStream(userFile)) {
			DemoUser tmpUser = getMapper().readValue(is, DemoUser.class);
			if (tmpUser.getPresets() != null) {
				tmpPresets.addAll(tmpUser.getPresets());
			}
			if (!StringTools.isEmpty(tmpUser.getSelectedPreset())) {
				tmpPresetId = tmpUser.getSelectedPreset();
			}
			/*
			 * migrate from earlier serialization
			 */
			if (tmpUser.getSettings() != null) {
				DemoPreset preset = new DemoPreset("default", tmpUser.getSettings());
				tmpPresets.add(preset);
				tmpUser.setSettings(null);
			}
			if (tmpUser.getDocuments() != null) {
				tmpDocuments.putAll(tmpUser.getDocuments());
			}
			if (tmpUser.getConfigurations() != null) {
				tmpConfigurations = tmpUser.getConfigurations();
			}
		} catch (FileNotFoundException e) {
			// ignore
		}
		user.setPresets(tmpPresets);
		user.setSelectedPreset(tmpPresetId);
		user.setDocuments(tmpDocuments);
		user.setConfigurations(tmpConfigurations);
	}

	public synchronized void save(DemoUser user, File userFile) throws IOException, JsonGenerationException,
			JsonMappingException,
			FileNotFoundException {
		try (OutputStream os = new FileOutputStream(userFile)) {
			getMapper().writeValue(os, user);
		}
	}
}
