import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';

import { DemoComponent } from './demo/demo.component';
import { DocumentsComponent } from './documents/documents.component';
import { EmbeddedViewComponent } from './embedded-view/embedded-view.component';
import { LogonComponent } from './logon/logon.component';
import { SettingsResolve } from './settings/settings-resolve.service';
import { SettingsComponent } from './settings/settings.component';

const routes: Routes = [
  { path: '', redirectTo: 'app', pathMatch: 'full' },
  { path: 'logon', component: LogonComponent },
  { path: 'embedded', component: EmbeddedViewComponent },
  {
    path: 'app',
    component: DemoComponent,
    /*
    canActivate: [AuthGuard],
    canActivateChild: [AuthGuard],
    */
    children: [
      { path: 'documents', component: DocumentsComponent },
      { path: 'settings', component: SettingsComponent, resolve: { dummy: SettingsResolve } }
    ]
  },
  { path: '**', redirectTo: '/app' }
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule { }
