import { Platform } from '@angular/cdk/platform';
import { Component } from '@angular/core';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})
export class AppComponent {
  title = 'cloud-suite-gears-demo';

  constructor(
    private platform: Platform
  ) {
    this.fixIosHeight()
  }

  private fixIosHeight() {
    /*
     * We want to fill all the available space, but on iOS browser's bottom edge is
     * outside the screen. The usual workaround to use "-webkit-fill-available"
     * messes with flex, so the only option seems to be to set to some calculated
     * pixels explicitly
     */
    // CDK can't detect iPad (at time of writing)
    if (this.platform.SAFARI && navigator.maxTouchPoints > 1) {
      // observe to detect orientation changes
      const observer = new ResizeObserver((entries: ResizeObserverEntry[]) => {
        // don't care about the individual entries
        document.body.style.height = `${window.innerHeight}px`
      });
      observer.observe(document.body.parentElement);
    }
  }
}
