import { HttpClientModule, HTTP_INTERCEPTORS } from '@angular/common/http';
import { ErrorHandler, NgModule } from '@angular/core';
import { FormsModule } from '@angular/forms';
import { MatButtonModule } from '@angular/material/button';
import { MatButtonToggleModule } from '@angular/material/button-toggle';
import { MatCardModule } from '@angular/material/card';
import { MatCheckboxModule } from '@angular/material/checkbox';
import { MatDialogModule } from '@angular/material/dialog';
import { MatDividerModule } from '@angular/material/divider';
import { MatIconModule } from '@angular/material/icon';
import { MatFormFieldModule, MAT_FORM_FIELD_DEFAULT_OPTIONS } from '@angular/material/form-field';
import { MatInputModule } from '@angular/material/input';
import { MatPaginatorModule } from '@angular/material/paginator';
import { MatSelectModule } from '@angular/material/select';
import { MatTableModule } from '@angular/material/table';
import { MatMenuModule } from '@angular/material/menu';
import { MatProgressBarModule } from '@angular/material/progress-bar';
import { MatSnackBarModule } from '@angular/material/snack-bar';
import { MatToolbarModule } from '@angular/material/toolbar';
import { MatTooltipModule } from '@angular/material/tooltip';
import { BrowserModule } from '@angular/platform-browser';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { NgJsonEditorModule } from 'ang-jsoneditor';
import { BlockUIModule } from 'ng-block-ui';
import { FileUploadModule } from 'ng2-file-upload';
import { NgxJsonViewerModule } from 'ngx-json-viewer';

import { AppRoutingModule } from './app-routing.module';
import { AppComponent } from './app.component';
import { AuthGuard } from './auth/auth.guard';
import { AuthInterceptor } from './auth/auth.interceptor';
import { AuthService } from './auth/auth.service';
import { ConversationMonitorComponent } from './conversation/conversation-monitor.component';
import { ConversationService } from './conversation/conversation.service';
import { DemoComponent } from './demo/demo.component';
import { DemoService } from './demo/demo.service';
import { DocumentSettingsComponent } from './documents/document-settings.component';
import { DocumentsComponent } from './documents/documents.component';
import { EmbeddedViewComponent } from './embedded-view/embedded-view.component';
import { AppErrorHandler } from './error/errorhandler.service';
import { LogonComponent } from './logon/logon.component';
import { NoticeService } from './notice/notice.service';
import { PinEntryComponent } from './pin-entry/pin-entry.component';
import { PinEntryService } from './pin-entry/pin-entry.service';
import { FileSizePipe } from './pipe/file-size.pipe';
import { PromptComponent } from './prompt/prompt.component';
import { RemoteService } from './service/remote.service';
import { SettingsResolve } from './settings/settings-resolve.service';
import { SettingsComponent } from './settings/settings.component';
import { SettingsService } from './settings/settings.service';
import { BusyIndicatorDirective } from './shared/busy/busy-indicator.directive';

@NgModule({
  declarations: [
    AppComponent,
    DemoComponent,
    SettingsComponent,
    DocumentSettingsComponent,
    DocumentsComponent,
    LogonComponent,
    PinEntryComponent,
    FileSizePipe,
    BusyIndicatorDirective,
    ConversationMonitorComponent,
    EmbeddedViewComponent,
    PromptComponent
  ],
  imports: [
    BlockUIModule.forRoot(),
    BrowserAnimationsModule,
    BrowserModule,
    FileUploadModule,
    FormsModule,
    HttpClientModule,
    MatButtonModule,
    MatButtonToggleModule,
    MatCardModule,
    MatCheckboxModule,
    MatDialogModule,
    MatDividerModule,
    MatFormFieldModule,
    MatIconModule,
    MatInputModule,
    MatMenuModule,
    MatPaginatorModule,
    MatProgressBarModule,
    MatSelectModule,
    MatSnackBarModule,
    MatToolbarModule,
    MatTooltipModule,
    MatTableModule,
    NgxJsonViewerModule,
    NgJsonEditorModule,
    AppRoutingModule
  ],
  providers: [
    { provide: ErrorHandler, useClass: AppErrorHandler },
    AuthGuard,
    AuthService,
    ConversationService,
    DemoService,
    NoticeService,
    PinEntryService,
    RemoteService,
    SettingsService,
    SettingsResolve,
    {
      provide: HTTP_INTERCEPTORS,
      useClass: AuthInterceptor,
      multi: true
    },
    {
      provide: MAT_FORM_FIELD_DEFAULT_OPTIONS,
      useValue: { appearance: 'fill' }
    }
  ],
  bootstrap: [AppComponent]
})
export class AppModule { }
