import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';
import { from } from 'rxjs';
import { catchError } from 'rxjs/operators';

import { AuthService } from '../auth/auth.service';
import { NoticeService } from '../notice/notice.service';
import { RemoteService } from '../service/remote.service';
import { BusyIndicator } from '../shared/busy/busy-indicator.service';

import * as metainfo from '../meta.json';

@Component({
  selector: 'app-logon',
  templateUrl: './logon.component.html',
  styleUrls: ['./logon.component.css']
})
export class LogonComponent implements OnInit {

  public metainfo = <any>metainfo.default;

  constructor(
    private router: Router,
    private authService: AuthService,
    private remoteService: RemoteService,
    private noticeService: NoticeService
  ) { }

  username: string;
  password: string;
  rememberMe: boolean;
  message: string;
  authModules: any[];
  loading = new BusyIndicator();

  ngOnInit() {
    this.loading.do(() => this.authService.getAuthModules()).subscribe((result) => {
      this.authModules = result;
    });
  }

  cancel() {
    this.router.navigate(['/app']);
  }

  authPassword() {
    const urlTarget = this.remoteService.toTargetUrl('authentication/password/logon');
    const request = {
      username: this.username,
      password: this.password
    };
    return this.remoteService
      .fetch(urlTarget, request, { message: 'Logon...' })
      .pipe(
        catchError(() => {
          this.noticeService.warning('Cannot contact server');
          return from(null);
        })
      )
      .subscribe(() => {
        const resumeTarget = this.remoteService.toTargetUrl('authentication/callback');
        window.location.href = resumeTarget;
      });
  }

  forward(module: string) {
    const targetUrl = this.remoteService.toTargetUrl('authentication/forward');
    let url;
    try {
      url = new URL(targetUrl);
    } catch(error) {
      url = new URL(this.remoteService.toExternalUrl(targetUrl));
    }
    url.searchParams.set('auth_module', module);
    window.location.href = url.toString();
  }

}
