import { Injectable, Injector } from '@angular/core';
import { MatDialog, MatDialogConfig } from '@angular/material/dialog';

import { PinEntryComponent } from './pin-entry.component';

@Injectable()
export class PinEntryService {

  public pinRequest: Promise<string>;

  public pinRequestResolve;

  public pinRequestReject;

  constructor(
    // injecting MatDialog currently causes circular dependency
    private injector: Injector
  ) { }

  public requestInput(stage) {
    const that = this;
    this.pinRequest = new Promise(function (resolve, reject) {
      that.pinRequestReject = reject;
      that.pinRequestResolve = resolve;
    });

    const dialogConfig = new MatDialogConfig();
    dialogConfig.autoFocus = true;
    dialogConfig.minWidth = '33vw';
    const dialog = this.injector.get(MatDialog);
    const dialogRef = dialog.open(PinEntryComponent, dialogConfig);
    dialogRef.afterClosed().subscribe(
      pin => {
        this.pinRequestResolve(pin);
      });

    return this.pinRequest;
  }
}
