import { BehaviorSubject, Observable, of, throwError } from 'rxjs';
import { finalize } from 'rxjs/operators';

export class BusyIndicator {

  active = new BehaviorSubject(false);

  public start() {
    this.active.next(true);
  }

  public stop() {
    this.active.next(false);
  }

  public do(f: () => any): Observable<any> {
    this.start();
    try {
      const result = f();
      if (result instanceof Observable) {
        return result.pipe(
          finalize(() => this.stop())
        );
      } else {
        this.stop();
        return of(result);
      }
    } catch (error) {
      return throwError(error);
    }
  }
}
