
function CommunicationError(code, message) {
	this.code = code;
    this.message = message;
    // this.stack = (new Error()).stack;
}
CommunicationError.prototype = Object.create(Error.prototype);
CommunicationError.prototype.constructor = CommunicationError;
CommunicationError.prototype.name = 'CommunicationError';

const ERR_MarshallingError = "Communication.MarshallingError";

const ERR_NoConnection = "Communication.NoConnection";

const ERR_HttpError = "Communication.HttpError";

const ERR_ProtocolError = "Communication.ProtocolError";

const XHR_STATUS_NOT_SET = 0;

const XHR_STATUS_OK = 200;

const XHR_STATUS_NO_CONTENT = 204;

const PROPERTY_WRAPPED = '_wrapped';

const PROPERTY_ERROR = '_error';

const PROPERTY_CODE = 'code';

const PROPERTY_MESSAGE = 'message';

function isTrue(value) {
	return value === "true" || value === "1" || value === true ;
}

function expand(value, context) {
	var regexp = /\$\{([^\}]+)\}/g;
	return value.replace(regexp, function(ignore, key) {
		return context[key] == null ? '' : encodeURIComponent(context[key]);
	});
}

function callJson(url, request) {
	return new Promise(
			function(resolve, reject) {
				var xhr = new XMLHttpRequest();
				xhr.onreadystatechange = function(error) {
					if (xhr.readyState == 4) {
						if (xhr.status == XHR_STATUS_NO_CONTENT) {
							return resolve(null);
						} else if (xhr.status == XHR_STATUS_OK) {
							if (xhr.response.size == 0) {
								return resolve(null);
							}
							try {
								var result = JSON.parse(xhr.responseText);
								if (result.hasOwnProperty(PROPERTY_WRAPPED)) {
									resolve(result[PROPERTY_WRAPPED]);
								} else {
									resolve(result);
								}
							} catch (e) {
								var code = ERR_MarshallingError; 
								var message = 'invalid json';
								reject(new CommunicationError(code, message));
							}
						} else {
							if (xhr.status == XHR_STATUS_NOT_SET) {
								/*
								 * lost connection or never had one in the first place
								 */
								reject(new CommunicationError(ERR_NoConnection, "0 - no status"));
							} else {
								var code = ERR_HttpError;
								var message = "" + xhr.status + " - " + xhr.responseText;
								try {
									var errorObject = JSON.parse(xhr.responseText);
									if (errorObject.hasOwnProperty(PROPERTY_ERROR)) {
										errorObject = errorObject._error;
									}
									if (errorObject.hasOwnProperty(PROPERTY_CODE)) {
										code = ERR_ProtocolError + "." + errorObject.code;
									}
									if (errorObject.hasOwnProperty(PROPERTY_MESSAGE)) {
										message = errorObject.message;
									}
									reject(new CommunicationError(code, message));
								} catch (e) {
									console
											.error(
													"cs: error in XMLHttpRequest: status %d, responseText %s",
													xhr.status,
													xhr.responseText);
									reject(new CommunicationError(code, message));
								}
							}
						}
					}
				}
				xhr.open('POST', url, true);
				xhr.responseType = "text";
				xhr.withCredentials = true;
				xhr.setRequestHeader('Content-Type', 'application/json');
				xhr.setRequestHeader('Accept', 'application/json');
				xhr.send(JSON.stringify(request));
			});
}

function callBlob(url, request) {
	return new Promise(
			function(resolve, reject) {
				var xhr = new XMLHttpRequest();
				xhr.onreadystatechange = function(error) {
					if (xhr.readyState == 4) {
						if (xhr.status == XHR_STATUS_NO_CONTENT) {
							return resolve(null);
						} else if (xhr.status == XHR_STATUS_OK) {
							if (xhr.response.size == 0) {
								return resolve(null);
							}
							resolve(xhr.response);
						} else {
							if (xhr.status == XHR_STATUS_NOT_SET) {
								/*
								 * lost connection or never had one in the first
								 * place
								 */
								reject(new CommunicationError(ERR_NoConnection, "0 - no status"));
							} else {
								var code = ERR_HttpError;
								var message = "" + xhr.status + " - " + xhr.response;
								console
										.error(
												"cs: error in XMLHttpRequest: status %d, response %s",
												xhr.status, xhr.response);
								reject(new CommunicationError(code, message));
							}
						}
					}
				}
				xhr.open('POST', url, true);
				xhr.responseType = "blob";
				xhr.setRequestHeader('Content-Type', 'application/json');
				xhr.setRequestHeader("Accept", "*/*");
				xhr.send(JSON.stringify(request));
			});
}
