/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.demo.auth;

import javax.security.auth.Subject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;

import de.intarsys.tools.functor.IArgs;

public abstract class CommonAuthContext implements IAuthContext {

	private Subject subject;

	private final CommonAuthModule authModule;

	private final IArgs args;

	public CommonAuthContext(CommonAuthModule authModule, Subject subject, IArgs args) {
		this.authModule = authModule;
		this.subject = subject;
		this.args = args;
	}

	public String authCallback(HttpServletRequest servletRequest) throws AuthenticationException {
		return null;
	}

	@Override
	public final Response authenticate(HttpServletRequest servletRequest) throws AuthenticationException {
		if (subject == null) {
			subject = new Subject();
		}
		return basicAuthenticate(servletRequest);
	}

	protected Response basicAuthenticate(HttpServletRequest servletRequest) throws AuthenticationException {
		return Response.ok().build();
	}

	protected void basicDeauthenticate() {
	}

	@Override
	public final void deauthenticate() {
		basicDeauthenticate();
		subject = null;
	}

	@Override
	public IArgs getArgs() {
		return args;
	}

	public CommonAuthModule getAuthModule() {
		return authModule;
	}

	@Override
	public Subject getSubject() {
		return subject;
	}

	protected void setSubject(Subject subject) {
		this.subject = subject;
	}

}
