/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.demo.auth;

import de.intarsys.tools.functor.IArgs;

public class OpenIdConnectModule extends CommonAuthModule {

	private String clientId;

	private String clientSecret;

	private String endpointAuthorization;

	private String endpointToken;

	private String endpointTokeninfo;

	private String scope;

	private String responseType;

	private String responseMode;

	private String display;

	private String prompt;

	private String issuer;

	@Override
	public IAuthContext createAuthContext(IArgs args) {
		OpenIdConnectContext result = new OpenIdConnectContext(this, null, args);
		return result;
	}

	public String getClientId() {
		return clientId;
	}

	public String getClientSecret() {
		return clientSecret;
	}

	public String getDisplay() {
		return display;
	}

	public String getEndpointAuthorization() {
		return endpointAuthorization;
	}

	public String getEndpointToken() {
		return endpointToken;
	}

	public String getEndpointTokeninfo() {
		return endpointTokeninfo;
	}

	public String getIssuer() {
		return issuer;
	}

	public String getPrompt() {
		return prompt;
	}

	public String getResponseMode() {
		return responseMode;
	}

	public String getResponseType() {
		return responseType;
	}

	public String getScope() {
		return scope;
	}

	public void setClientId(String clientId) {
		this.clientId = clientId;
	}

	public void setClientSecret(String clientSecret) {
		this.clientSecret = clientSecret;
	}

	public void setDisplay(String display) {
		this.display = display;
	}

	public void setEndpointAuthorization(String endpointAuthorization) {
		this.endpointAuthorization = endpointAuthorization;
	}

	public void setEndpointToken(String endpointToken) {
		this.endpointToken = endpointToken;
	}

	public void setEndpointTokeninfo(String endpointTokeninfo) {
		this.endpointTokeninfo = endpointTokeninfo;
	}

	public void setIssuer(String issuer) {
		this.issuer = issuer;
	}

	public void setPrompt(String prompt) {
		this.prompt = prompt;
	}

	public void setResponseMode(String responseMode) {
		this.responseMode = responseMode;
	}

	public void setResponseType(String responseType) {
		this.responseType = responseType;
	}

	public void setScope(String scope) {
		this.scope = scope;
	}

}
