/*
 *   o_
 * in|tarsys GmbH (c)
 *
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.demo.config;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.glassfish.jersey.logging.LoggingFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.springframework.stereotype.Component;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;

import de.intarsys.cloudsuite.gears.core.service.common.jackson.ITransportItemLocatorFactory;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportDocumentLocatorDeserializer;
import de.intarsys.tools.file.TempTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import jakarta.ws.rs.ApplicationPath;

@Component
@ApplicationPath("/api")
public class JerseyConfig extends ResourceConfig {

	private static final String VALUE_TRUE = "true";

	private static final int MAX_LENGTH = 1000;

	public JerseyConfig() {
		// oh god, jersey is just another mess....
		property("jersey.config.server.wadl.disableWadl", VALUE_TRUE);
		property("com.sun.jersey.config.feature.DisableWADL", VALUE_TRUE);
		register(MultiPartFeature.class);
		register(JacksonJsonProvider.class);
		register(new LoggingFeature(Logger.getLogger("jaxrs"), Level.FINER, LoggingFeature.Verbosity.PAYLOAD_ANY,
				MAX_LENGTH));
		// scan the resources package for our resources
		packages( //
				"de.intarsys.cloudsuite.gears.demo" //
		);
		/*
		 * here we set up a factory to create temp files.
		 */
		ITransportItemLocatorFactory factory = new ITransportItemLocatorFactory() {
			private int counter;

			@Override
			public ILocator createLocator(JsonParser parser, DeserializationContext ctxt) throws IOException {
				return new FileLocator(new File(TempTools.getTempDir(), "download-" + counter++ + ".bytes"));
			}
		};
		TransportDocumentLocatorDeserializer.setLocatorFactory(factory);
	}
}