/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.demo.service;

import java.util.Map;

import de.intarsys.cloudsuite.gears.demo.model.DemoDoc;

public class DtoDocState {

	private String name;

	private boolean signed;

	private boolean viewed;

	private boolean timestamped;

	private long length;

	private Map<String, String> properties;

	public DtoDocState() {
	}

	public DtoDocState(DemoDoc doc) {
		this.setName(doc.getName());
		this.setLength(doc.getLength());
		this.setSigned(doc.isSigned());
		this.setViewed(doc.isViewed());
		this.setTimestamped(doc.isTimestamped());
		this.setProperties(doc.getProperties());
	}

	public long getLength() {
		return length;
	}

	public String getName() {
		return name;
	}

	public Map<String, String> getProperties() {
		return properties;
	}

	public boolean isSigned() {
		return signed;
	}

	public boolean isViewed() {
		return viewed;
	}

	public void setLength(long length) {
		this.length = length;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setProperties(Map<String, String> properties) {
		this.properties = properties;
	}

	public void setSigned(boolean signed) {
		this.signed = signed;
	}

	public void setViewed(boolean viewed) {
		this.viewed = viewed;
	}

	public boolean isTimestamped() {
		return timestamped;
	}

	public void setTimestamped(boolean timestamped) {
		this.timestamped = timestamped;
	}
}
