/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.demo.service;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;

import org.springframework.beans.factory.annotation.Autowired;

import de.intarsys.cloudsuite.gears.demo.auth.IAuthContext;
import de.intarsys.cloudsuite.gears.demo.auth.UserPasswordContext;
import de.intarsys.cloudsuite.gears.demo.jaxrs.Authenticated;
import de.intarsys.cloudsuite.gears.demo.model.AuthenticationBackend;
import de.intarsys.cloudsuite.gears.demo.model.DemoUser;

@Path("/v1/authentication")
public class SvcAuthentication implements Serializable {

	@Autowired
	private AuthenticationBackend authenticationBackend;

	@Context
	private ContainerRequestContext requestContext;

	@GET
	@Path("/callback")
	public Response callback(@Context HttpServletRequest servletRequest) throws Exception {
		return getAuthenticationBackend().callback(servletRequest);
	}

	@GET
	@Path("/forward")
	public Response forward(@Context HttpServletRequest servletRequest, @QueryParam("auth_module") String id)
			throws Exception {
		return getAuthenticationBackend().forward(servletRequest, id);
	}

	protected AuthenticationBackend getAuthenticationBackend() {
		return authenticationBackend;
	}

	@POST
	@Path("/getModules")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public List<DtoAuthModule> getModules() throws Exception {
		return getAuthenticationBackend().getAuthModules().stream().map((module) -> new DtoAuthModule(module))
				.collect(Collectors.toList());
	}

	@Authenticated
	@POST
	@Path("/getUser")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public ResponseAuthGetUser getUser() throws IOException {
		ResponseAuthGetUser response = new ResponseAuthGetUser();
		DemoUser demoUser = (DemoUser) requestContext.getProperty("user");
		if (demoUser == null) {
			return null;
		}
		DtoUser user = new DtoUser();
		user.setName(demoUser.getName());
		response.setUser(user);
		return response;
	}

	@POST
	@Path("/logout")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public Response logout() throws Exception {
		getAuthenticationBackend().logout();
		return Response.noContent().build();
	}

	@POST
	@Path("/password/logon")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public void passwordLogon(RequestAuthPasswordLogon request) throws Exception {
		IAuthContext authContext = getAuthenticationBackend().getAuthContext();
		if (!(authContext instanceof UserPasswordContext)) {
			throw new IllegalStateException("no authentication context");
		}
		((UserPasswordContext) authContext).logon(request.getUsername(), request.getPassword());
	}

	@GET
	@Path("/request")
	public Response request(@Context HttpServletRequest servletRequest, @QueryParam("auth_module") String id,
			@QueryParam("auth_callback") String callback, @QueryParam("auth_state") String state) throws Exception {
		return getAuthenticationBackend().request(servletRequest, id, callback, state);
	}

}
