/*
 *   o_
 * in|tarsys GmbH (c)
 *   
 * all rights reserved
 *
 */
package de.intarsys.cloudsuite.gears.demo.service;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;

import org.springframework.stereotype.Component;

import de.intarsys.cloudsuite.gears.core.service.meta.api.ResponseVersion;
import de.intarsys.tools.component.ComponentInfo;
import de.intarsys.tools.jaxrs.ServiceImplementor;
import de.intarsys.tools.reflect.ClassTools;

@ServiceImplementor
@Path("/v1/meta")
@Component
public class SvcMeta {

	@GET
	@Path("/version")
	@Produces(MediaType.APPLICATION_JSON)
	public ResponseVersion getVersion() {
		ComponentInfo info = new ComponentInfo();
		info.readFromContainer(ClassTools.getContainerResourceUrl(getClass()));
		ResponseVersion response = new ResponseVersion();
		response.setVersion(info.getVersion());
		response.setBuild(info.getBuild());
		response.setTimestamp(info.getTimestamp());
		return response;
	}
}
