import { Routes } from '@angular/router';

import { DemoComponent } from './demo/demo.component';
import { DocumentsComponent } from './documents/documents.component';
import { LogonComponent } from './logon/logon.component';
import { SettingsResolve } from './settings/settings-resolve.service';
import { SettingsComponent } from './settings/settings.component';

export const routes: Routes = [
  { path: '', redirectTo: 'app', pathMatch: 'full' },
  { path: 'logon', component: LogonComponent },
  { path: 'embedded', loadComponent: () => import('./embedded-view/embedded-view.component').then(imported => imported.EmbeddedViewComponent) },
  {
    path: 'app',
    component: DemoComponent,
    /*
    canActivate: [AuthGuard],
    canActivateChild: [AuthGuard],
    */
    children: [
      { path: 'documents', component: DocumentsComponent },
      { path: 'settings', component: SettingsComponent, resolve: { dummy: SettingsResolve } }
    ]
  },
  { path: '**', redirectTo: '/app' }
];
