
import { ConversationService } from './conversation.service';
import { ReplyStage } from './reply-stage.model';

declare var ConversationHandler: any;

export class ConversationMonitor {

  atEnd = false;

  taskName: string;

  subTaskName: string;

  work: number;

  worked: number;

  conversation: string;

  constructor(
    private conversationService: ConversationService
  ) {
    this.taskName = 'Please wait...';
    this.work = -1;
  }

  isIndeterminate() {
    return this.work <= 0;
  }

  getMode() {
    if (this.atEnd) {
      return 'determinate';
    }
    if (this.work <= 0) {
      return 'indeterminate';
    }
    return 'determinate';
  }

  getPercent() {
    if (this.atEnd) {
      return 100;
    }
    if (this.work !== 0) {
      return (this.worked / this.work) * 100;
    }
    return 0;
  }

  public isAtEnd() {
    return this.atEnd;
  }

  public begin(taskName: string, work = -1) {
    this.taskName = taskName;
    this.work = work;
  }

  public end() {
    if (this.atEnd) {
      return;
    }
    this.atEnd = true;
    this.conversationService.destroyMonitor(this);
  }

  public update(snapshot: any) {
    if (!snapshot || !snapshot.conversation) {
      return;
    }
    this.conversation = snapshot.conversation;
    if (!snapshot.stage) {
      return;
    }
    const stage = new ReplyStage(snapshot.stage);
    this.subTaskName = stage.getLabel();
    this.work = stage.getWork();
    this.worked = stage.getWorked();
  }

  public isCancelable(): boolean {
    return !!this.conversation && !this.atEnd;
  }

  public cancel(): void {
    this.conversationService.cancel(this.conversation).subscribe();
  }

}
