const SCHEME_RESULT = 'urn:intarsys:names:conversation:1.0:schemes:Result';

const SCHEME_ERROR = 'urn:intarsys:names:conversation:1.0:schemes:Error';

const SCHEME_CANCEL = 'urn:intarsys:names:conversation:1.0:schemes:Cancel';

export class ReplyStage {

  scheme: string;
  id: string;
  value: any;

  constructor(value: any) {
    this.scheme = value.scheme;
    this.id = value.id;
    this.value = value;
  }

  isFinal() {
    return this.isCancel() || this.isError() || this.isResult();
  }

  isError() {
    return this.scheme === SCHEME_ERROR;
  }

  getError() {
    if (this.scheme === SCHEME_ERROR) {
      return this.value.error;
    }
    if (this.scheme === SCHEME_CANCEL) {
      return new Error('conversation canceled');
    }
    return null;
  }

  isResult() {
    return this.scheme === SCHEME_RESULT;
  }

  getResult() {
    if (this.scheme === SCHEME_RESULT) {
      return this.value.result;
    }
    return null;
  }

  isCancel() {
    return this.scheme === SCHEME_CANCEL;
  }

  getLabel() {
    if (this.scheme === SCHEME_RESULT) {
      return 'Finished';
    } else if (this.scheme === SCHEME_ERROR) {
      return 'Failed';
    } else if (this.scheme === SCHEME_CANCEL) {
      return 'Canceled';
    } else {
      if (this.value.message) {
        return this.value.message;
      }
      return 'Working...';
    }
  }

  getWork() {
    if (this.value.work) {
      return this.value.work;
    }
    return -1;
  }

  getWorked() {
    if (this.value.worked) {
      return this.value.worked;
    }
    return 0;
  }

}
