import { CdkScrollable } from "@angular/cdk/scrolling";
import { Component, Inject } from "@angular/core";
import { FormsModule } from "@angular/forms";
import { MatButton } from "@angular/material/button";
import { MAT_DIALOG_DATA, MatDialogActions, MatDialogClose, MatDialogContent, MatDialogRef, MatDialogTitle } from "@angular/material/dialog";
import { MatFormField, MatLabel } from "@angular/material/form-field";
import { MatInput } from "@angular/material/input";

interface DocumentSettingsData {
  docProperties: any;
}

@Component({
    templateUrl: './document-settings.component.html',
    imports: [MatDialogTitle, CdkScrollable, MatDialogContent, MatFormField, MatLabel, MatInput, FormsModule, MatDialogActions, MatButton, MatDialogClose],
    styleUrls: ['./document-settings.component.scss']
})
export class DocumentSettingsComponent {
  constructor(
    public dialogRef: MatDialogRef<DocumentSettingsComponent>,
    @Inject(MAT_DIALOG_DATA) public data: DocumentSettingsData
  ) { }

  cancel() {
    this.dialogRef.close();
  }
}
