import { ErrorHandler, Injectable, Injector, NgZone } from '@angular/core';
import { Router } from '@angular/router';

import { environment } from '../../environments/environment';
import { AuthService } from '../auth/auth.service';
import { NoticeService } from '../notice/notice.service';

@Injectable()
export class AppErrorHandler extends ErrorHandler {

  constructor(
    private injector: Injector,
    private zone: NgZone
  ) {
    super();
  }

  override handleError(error: any): void {
    if (!environment.production) {
      super.handleError(error);
    }
    let realError = error;
    if (error.rejection) {
      realError = error.rejection;
    }
    let type = 'error';
    const title = '';
    let message;
    if (realError.message) {
      message = realError.message;
    } else {
      message = '' + realError;
    }
    if (realError.code) {
      if (realError.code.indexOf('Conversation.CancelStage') === 0) {
        type = 'info';
        message = 'Conversation canceled';
      }
      if (realError.code === 'Unauthorized' || realError.code === 'Forbidden') {
        // some firewalls map 401 -> 403 when we initially present a then expired token
        type = 'info';
        message = 'You need to log in';
        const authService = this.injector.get(AuthService);
        authService.logout().subscribe();
        const router = this.injector.get(Router);
        console.log('errorhandler navigates to main');
        this.zone.run(() => { router.navigate(['/app']) });
      }
      if (realError.code.indexOf('ConversationExpired') === 0) {
        type = 'warning';
        message = 'Conversation expired: You need to restart your activity';
      }
    }
    const noticeService = this.injector.get(NoticeService);
    noticeService.notice(type, message, title);
  }

}
